#ifndef _ltc2704spi_h_
#define _ltc2704spi_h_ 1


//Use these by ORing the Command and the Address together and sending as first byte


/* 
** SPI Command Operations
** Defined as the top nibble of the first byte
*/

//Write
#define LTC2704_CMD_WRITE_SPAN_N                       (0x20)  //B1span-n
#define LTC2704_CMD_WRITE_CODE_N                       (0x30)  //B1code-n
#define LTC2704_CMD_UPDATE_N                           (0x40)  //B2span-n
#define LTC2704_CMD_UPDATE_ALL                         (0x50)  //B2code-A


#define LTC2704_CMD_WRITE_SPAN_N_UPDATE_N              (0x60)  //B2span-n
#define LTC2704_CMD_WRITE_CODE_N_UPDATE_N              (0x70)  //B2code-n

#define LTC2704_CMD_WRITE_SPAN_N_UPDATE_ALL            (0x80)  //B2span-n
#define LTC2704_CMD_WRITE_CODE_N_UPDATE_ALL            (0x90)  //B2code-n


#define LTC2704_CMD_READ_B1_SPAN_N                     (0xA0)
#define LTC2704_CMD_READ_B1_CODE_N                     (0xB0)

#define LTC2704_CMD_READ_B2_SPAN_N                     (0xC0)
#define LTC2704_CMD_READ_B2_CODE_N                     (0xD0)


#define LTC2704_CMD_SLEEP_N                            (0xE0)  //B2span-n
#define LTC2704_CMD_NO_OPERATION                       (0xF0)  //B2code-n



/* 
** SPI Address Operations
** Defined as the bottom of the first byte
*/
#define LTC2704_ADR_DAC_A                         (0x00)
#define LTC2704_ADR_DAC_B                         (0x02)
#define LTC2704_ADR_DAC_C                         (0x04)
#define LTC2704_ADR_DAC_D                         (0x06)
#define LTC2704_ADR_DAC_ALL                       (0x0F)



/* 
** SPI Span Codes
** Defined as the 4 LSB of the 16 data bits
*/
#define LTC2704_SPAN_UNIPOLAR_0_5                      (0x00)
#define LTC2704_SPAN_UNIPOLAR_0_10                     (0x01)
#define LTC2704_SPAN_BIPOLAR_5_5                      (0x02)
#define LTC2704_SPAN_BIPOLAR_10_10                    (0x03)
#define LTC2704_SPAN_BIPOLAR_2V5_2V5                  (0x04)
#define LTC2704_SPAN_BIPOLAR_2V5_7V5                  (0x05)


//Function Definitions

extern uint_32		send_LTC2704 (uint_8, uint_8, uint_32, FILE_PTR);
extern uint_32		send_receive_LTC2704 (uint_8, uint_8, uint_32, FILE_PTR);



static const uint_8 LTC2704CodeCommandSelect[] = 
{
	LTC2704_CMD_WRITE_CODE_N,
	LTC2704_CMD_WRITE_CODE_N_UPDATE_N,
	LTC2704_CMD_WRITE_CODE_N_UPDATE_ALL
};


static const uint_8 LTC2704SpanCommandSelect[] = 
{
	LTC2704_CMD_WRITE_SPAN_N,
	LTC2704_CMD_WRITE_SPAN_N_UPDATE_N,
	LTC2704_CMD_WRITE_SPAN_N_UPDATE_ALL
};

static const uint_8 LTC2704CommandSelect[] = 
{
	LTC2704_CMD_UPDATE_N,
	LTC2704_CMD_UPDATE_ALL,
	
	LTC2704_CMD_READ_B1_SPAN_N,
	LTC2704_CMD_READ_B1_CODE_N,
	
	LTC2704_CMD_READ_B2_SPAN_N,
	LTC2704_CMD_READ_B2_CODE_N,
	
	LTC2704_CMD_SLEEP_N,
	LTC2704_CMD_NO_OPERATION
};




static const uint_8 LTC2704ChannelSelect[] = 
{
	LTC2704_ADR_DAC_A,
	LTC2704_ADR_DAC_B,
	LTC2704_ADR_DAC_C,
	LTC2704_ADR_DAC_D,
	LTC2704_ADR_DAC_ALL
};


static const uint_8 LTC2704SpanSelect[] = 
{
	LTC2704_SPAN_UNIPOLAR_0_5,
	LTC2704_SPAN_UNIPOLAR_0_10,
	LTC2704_SPAN_BIPOLAR_5_5,
	LTC2704_SPAN_BIPOLAR_10_10,
	LTC2704_SPAN_BIPOLAR_2V5_2V5,
	LTC2704_SPAN_BIPOLAR_2V5_7V5
};



#endif /* _ltc2704spi_h_ */

